# -*- coding: utf-8 -*-
"""
Created on Thu Mar 31 16:09:11 2016

@author: gareth
"""
#from CAnalysis import CAnalysis

class CPostProcessingModule:
    
    def __init__(self):
        self.Analyses = []
        
    def GetAnalysesWidths(self):
        widths = []
        for analysis in self.Analyses:
            widths.append(analysis.River.Width)
        return widths
        
    def GetAdvectionOnlyResiduals(self):
        residuals = []
        for analysis in self.Analyses:
            r = analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(analysis.Models.AdvectionOnly)
            residuals.append(r)
        return residuals        
        
    def GetAdvectionADELongitudinalResiduals(self):
        residuals = []
        for analysis in self.Analyses:
            r = analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(analysis.Models.ADELongitudinal)
            residuals.append(r)
        return residuals   
        
    def GetAdvectionADETransverseResiduals(self):
        residuals = []
        for analysis in self.Analyses:
            r = analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(analysis.Models.ADETransverse)
            residuals.append(r)
        return residuals   
        
    def GetAdvectionADZResiduals(self):
        residuals = []
        for analysis in self.Analyses:
            r = analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(analysis.Models.ADZ)
            residuals.append(r)
        return residuals           

